package tomek.it.graphics;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;

public class CardPanel05 {
	
	private static final Logger log = LogManager.getLogger(CardPanel05.class);

	private final static int defaultWidth = 320;
	private final static int defaultHeight = 240;

	private final static String[] countries = { "Afghanistan", "Albania", "Argentina", "Austria", "Belgium", "Brazil",
			"Cambodia", "Cameroon", "Canada", "Chile", "China", "Colombia", "Costa Rica", "Croatia", "Czech Republic",
			"Denmark", "Egypt", "France", "Germany", "Hungary", "Iceland", "India", "Indonesia", "Iran", "Ireland",
			"Israel", "Italy", "Jamaica", "Japan", "Kenya", "Mexico", "Morocco", "Nepal", "Netherlands", "New Zealand",
			"Nigeria", "Norway", "Peru", "Philippines", "Poland", "Portugal", "Romania", "Russia", "Saudi Arabia",
			"Serbia", "Slovakia", "South Africa", "South Korea", "Spain", "Sweden", "Switzerland", "Thailand",
			"Ukraine", "United States", "Uruguay", };
	private final static int POLAND = 39;

	final private static JLabel labelFlag = new JLabel();	
	final private static JLabel labelHTML = new JLabel();	

	private final static Icon[] countriesIcon = new Icon[countries.length];
	private final static String[] countriesIconError = new String[countries.length];
	private final static String[] countriesHTML = new String[countries.length];
	private final static String[] countriesHTMLError = new String[countries.length];

	
	private static void createAndShowGUI() {

		Configurator.initialize(new DefaultConfiguration());
	    Configurator.setRootLevel(Level.TRACE);
		
		JFrame f = new JFrame("CardLayout DEMO");

		final JPanel control = new JPanel(new GridLayout());
		final JButton jbuttonNext = new JButton();
		final JButton jbuttonPrevious = new JButton();
		final JComboBox<String> jlist = new JComboBox<String>(countries);

		final ImageIcon iiPrevious = new ImageIcon("ICON/arrow-left_red.png");
		final ImageIcon iiNext = new ImageIcon("ICON/arrow-right_red.png");

		final JPanel cards = new JPanel(new CardLayout());
		final String FLAG = "FLAG";
		final String HTML = "HTML";
		final JPanel jpFlag = new JPanel();
		final JPanel jpHTML = new JPanel();
		
		
		ActionListener myActionListener = new ActionListener() {
			
			int i;
			
			public synchronized void actionPerformed(ActionEvent e) {
				i = jlist.getSelectedIndex();
				
				if (e.getSource().equals(jbuttonNext)) {
					i++;
					if (i == countries.length)
						i = 0;
					jlist.setSelectedIndex(i);
					log.trace("[ActionListener]: NEXT Button \""+countries[i]+"\" ("+i+")");
					return;
				}
				if (e.getSource().equals(jbuttonPrevious)) {
					i--;
					if (i < 0)
						i = countries.length - 1;
					jlist.setSelectedIndex(i);
					log.trace("[ActionListener]: PREVIOUS Button \""+countries[i]+"\" ("+i+")");
					return;
				}
				log.error("[ActionListener] Unknown object...");
			}
		};

		MouseListener myMouseListener = new MouseListener() {

			CardLayout cl = (CardLayout) cards.getLayout();
			int i;

			public void mouseClicked(MouseEvent e) {}

			public synchronized void mousePressed(MouseEvent e) {
				i = jlist.getSelectedIndex();
				cl.next(cards);
				if (jpFlag.isVisible()) {
					log.trace("[MouseListener]: "+ "Selected FLAG Panel for \""+countries[i]+"\" ("+i+") - now: \""+labelFlag.getName()+"\"");
					// If previously set valid flag - skipping
					if(countries[i]!=labelFlag.getName()) setLabelFlag(i);
					return;
				}
				else if (jpHTML.isVisible()) {
					log.trace("[MouseListener]: "+ "Selected HTML Panel for \""+countries[i]+"\" ("+i+") - now: \""+labelHTML.getName()+"\"");
					// If previously set valid HTML - skipping
					if(countries[i]!=labelHTML.getName()) setLabelHTML(i);
				}
				else {
					log.error("[MouseListener]: WRONG PANEL... ");
				}
			}

			public void mouseReleased(MouseEvent e) {}

			public void mouseEntered(MouseEvent e) {}

			public void mouseExited(MouseEvent e) {}

		};

		jbuttonNext.setIcon(iiNext);
		jbuttonNext.setBorderPainted(false);
		jbuttonNext.setContentAreaFilled(false);
		jbuttonNext.setBorder(null);
		jbuttonNext.setFocusPainted(false);
		jbuttonNext.setMargin(new Insets(0, 0, 0, 0));
		jbuttonNext.addActionListener(myActionListener);

		jbuttonPrevious.setIcon(iiPrevious);
		jbuttonPrevious.setBorderPainted(false);
		jbuttonPrevious.setContentAreaFilled(false);
		jbuttonPrevious.setBorder(null);
		jbuttonPrevious.setFocusPainted(false);
		jbuttonPrevious.setMargin(new Insets(0, 0, 0, 0));
		jbuttonPrevious.addActionListener(myActionListener);

		jlist.setBackground(Color.LIGHT_GRAY);
		jlist.setForeground(Color.BLUE);
		jlist.setFont(new Font("Verdana", Font.BOLD, 12));

		// JPanel - sterujący
		control.setBackground(Color.DARK_GRAY);

		control.add(jbuttonPrevious);
		control.add(jlist);
		control.add(jbuttonNext);

		// JPanel - składniki głównego okienko
		jpFlag.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
		jpFlag.setBackground(Color.DARK_GRAY);
		jpFlag.addMouseListener(myMouseListener);
		jpFlag.setName(FLAG);
		jpFlag.add(labelFlag);

		jpHTML.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
		jpHTML.setBackground(Color.DARK_GRAY);
		jpHTML.addMouseListener(myMouseListener);
		jpHTML.setName(HTML);
		jpHTML.add(labelHTML);


		
		ItemListener myItemListener = new ItemListener() {
			
			int i;
			
			public synchronized void itemStateChanged(ItemEvent ie) {
				if (ie.getStateChange()==ItemEvent.SELECTED) {
					i = jlist.getSelectedIndex();
					if (jpFlag.isVisible()) {
						log.trace("[ItemListener]: "+ "Setting FLAG Panel for \""+countries[i]+"\" ("+i+") - now: \""+labelFlag.getName()+"\"");
						// This should always set new labelFlag 
						if (countries[i]==labelFlag.getName())
							log.error("current must differ than new! \""+countries[i]+"\"==\""+labelFlag.getName()+"\"");
						setLabelFlag(i);
					}
					else if (jpHTML.isVisible()) {
						log.trace("[ItemListener]: "+ "Setting HTML Panel for \""+countries[i]+"\" ("+i+") - now: \""+labelHTML.getName()+"\"");
						// This should always set new labelHTML
						if (countries[i]==labelHTML.getName())
							log.error("current must differ than new! \""+countries[i]+"\"==\""+labelHTML.getName()+"\"");
						setLabelHTML(i);
					} 
					else {
						log.error("[ItemListener]: WRONG PANEL... "+ ie.paramString());
					}
				}
			}
		};

		jlist.addItemListener(myItemListener);
		jlist.setSelectedIndex(POLAND);

		cards.add(jpFlag);
		cards.add(jpHTML);

		f.add(cards, BorderLayout.CENTER);
		f.add(control, BorderLayout.NORTH);

		f.pack();
		f.setLocationRelativeTo(null);
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setVisible(true);
	}

	
	
	private static void setLabelHTML(int i) {

		log.trace("[setLabelHTML]: Setting HTML for \""+countries[i]+"\" ("+i+")");
		// sprawdzam czy już ustawione
		// pobieram to co trzeba i zapusuję do tablicy, lub do tablicy błędów...
		// jeśli znowu jestem na tym focusie to ustawiam Label i name dla Label. 
		
		if (countriesHTML[i] != null) {
			log.trace("[setLabelHTML]: Use existing HTML for \""+countries[i]+"\"");			
			labelHTML.setText(countriesHTML[i]);
			labelHTML.setName(countries[i]);
			return;
		}
		if (countriesHTMLError[i] != null) {
			log.trace("[setLabelHTML]: Use existing Error HTML for \""+countries[i]+"\"");			
			labelHTML.setText(countriesHTMLError[i]);
			labelHTML.setName(countries[i]);
			return;
		}
	}

	private static void setLabelFlag(int i) {

		log.trace("[setLabelFlag]: Setting Icon for \""+countries[i]+"\" ("+i+")");
		// sprawdzam czy już ustawione
		// pobieram to co trzeba i zapusuję do tablicy, lub do tablicy błędów...
		// jeśli znowu jestem na tym focusie to ustawiam Label i name dla Label. 
		
		if (countriesIcon[i] != null) {
			log.trace("[setLabelFlag]: Use existing Icon for \""+countries[i]+"\"");		
			labelFlag.setIcon(countriesIcon[i]);
			labelFlag.setText(null);
			labelFlag.setName(countries[i]);
			return;
		}
		if (countriesIconError[i] != null) {
			log.trace("[setLabelFlag]: Use existing Error Icon for \""+countries[i]+"\"");			
			labelFlag.setIcon(null);
			labelFlag.setText(countriesIconError[i]);
			labelFlag.setName(countries[i]);
			return;
		}
	
	}
	
	
	public static void main(String[] args) {

		UIManager.put("ComboBox.selectionForeground", new ColorUIResource(Color.YELLOW));
		
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}

}
